/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import com.mojang.brigadier.CommandDispatcher;
import corgitaco.corgilib.CorgiLibFabric;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_5132;
import potionstudios.byg.BYG;
import potionstudios.byg.common.BYGCompostables;
import potionstudios.byg.common.BYGFuels;
import potionstudios.byg.common.BYGStrippables;
import potionstudios.byg.common.block.BYGScaffoldingBlock;
import potionstudios.byg.common.entity.BYGEntities;
import potionstudios.byg.common.entity.manowar.ManOWar;
import potionstudios.byg.common.entity.npc.TradesConfig;
import potionstudios.byg.common.entity.pumpkinwarden.PumpkinWarden;
import potionstudios.byg.common.item.BYGCreativeTab;
import potionstudios.byg.common.item.BYGItems;
import potionstudios.byg.core.BYGRegistry;
import potionstudios.byg.network.FabricNetworkHandler;

public class BYGFabric
implements ModInitializer {
    private static String firstInitialized = null;

    public void onInitialize() {
        BYGFabric.initializeBYG("BYG Fabric Mod Initializer");
    }

    public static void initializeBYG(String initializedFrom) {
        CorgiLibFabric.initializeCorgiLib((String)initializedFrom);
        Objects.requireNonNull(initializedFrom, "BYG must be told where it was initialized from.");
        if (firstInitialized != null || BYG.INITIALIZED) {
            BYG.logDebug(String.format("Attempted to Initialize Oh The Biomes You'll Go (BYG) from \"%s\" but BYG already was initialized from \"%s\", this should not be a problem.", initializedFrom, firstInitialized));
            return;
        }
        firstInitialized = initializedFrom;
        BYG.INITIALIZED = true;
        BYGFabric.registryBootStrap();
        BYGRegistry.loadClasses();
        BYGFabric.registerRenderers();
        BYGFuels.loadFuels((arg_0, arg_1) -> ((FuelRegistry)FuelRegistry.INSTANCE).add(arg_0, arg_1));
        CommandRegistrationCallback.EVENT.register((dispatcher, commandBuildContext, commandSelection) -> BYG.attachCommands((CommandDispatcher<class_2168>)dispatcher, commandSelection));
        FabricNetworkHandler.init();
        BYG.logInfo(String.format("Oh The Biomes You'll Go (BYG) was initialized from \"%s\"", initializedFrom));
    }

    public static void registerRenderers() {
        FabricDefaultAttributeRegistry.register(BYGEntities.MAN_O_WAR.get(), (class_5132.class_5133)ManOWar.createAttributes());
        FabricDefaultAttributeRegistry.register(BYGEntities.PUMPKIN_WARDEN.get(), (class_5132.class_5133)PumpkinWarden.createAttributes());
    }

    public static void afterRegistriesFreeze() {
        BYG.commonLoad();
        BYG.blockToInstanceOfReplacement(class_2246.field_16492, BYGScaffoldingBlock.class);
        BYG.threadSafeCommonLoad();
        BYG.threadSafeLoadFinish();
        BYGCompostables.COMPOSTABLES.get().forEach((arg_0, arg_1) -> ((CompostingChanceRegistry)CompostingChanceRegistry.INSTANCE).add(arg_0, arg_1));
        BYGFabric.registerVillagerTrades();
        BYGStrippables.strippableLogsBYG(StrippableBlockRegistry::register);
        BYG.logInfo("\"Oh The Biomes You'll Go\" after registries freeze event complete!");
    }

    private static void registerVillagerTrades() {
        TradesConfig tradesConfig = TradesConfig.getConfig();
        if (tradesConfig.enabled()) {
            tradesConfig.tradesByProfession().forEach((professionKey, int2ObjectMap) -> {
                Optional profession = class_2378.field_17167.method_17966(professionKey);
                if (profession.isPresent()) {
                    int2ObjectMap.forEach((level, configListing) -> TradeOfferHelper.registerVillagerOffers((class_3852)((class_3852)profession.get()), (int)level, itemListings -> itemListings.addAll(Arrays.asList(configListing))));
                } else {
                    BYG.logWarning("\"%s\" is not a registered villager profession, skipping trade entry...".formatted(professionKey.toString()));
                }
            });
            tradesConfig.wanderingTraderTrades().forEach((level, listings) -> TradeOfferHelper.registerWanderingTraderOffers((int)level, itemListings -> itemListings.addAll(Arrays.asList(listings))));
        } else {
            BYG.logWarning("Ignoring villager/wandering trader trades added by BYG.");
        }
    }

    private static void registryBootStrap() {
        BYGCreativeTab.init(FabricItemGroupBuilder.build((class_2960)BYG.createLocation("byg"), () -> new class_1799((class_1935)BYGItems.BYG_LOGO.get())));
        BYG.logInfo("BYG registries bootstrapped");
    }
}

